import streamlit as st      
import gradio as gr
import IPython
import streamlit as st
import streamlit.components.v1 as components
from IPython.display import IFrame

#quantum imports:
import qiskit
from qiskit import QuantumCircuit, QuantumRegister, execute

src=''   # URL parameter to change the iframe url

def SetIframeURL(option_selected):
    if (option_selected=='QCEngine'):
        src='https://oreilly-qc.github.io?p=2-1'
    if (option_selected=='Grok'):
        src='https://javafxpert.github.io/grok-bloch/'
    if (option_selected=='Playground'):
        src='https://davidbkemp.github.io/quantum-gate-playground/'
    if (option_selected=='Circuit'):
        src='https://algassert.com/quirk#circuit={%22cols%22:[[%22H%22],[%22Bloch%22],[%22Measure%22]]}'
    
    # Render iframe contents
    #st.set_page_config(layout="wide")
    width = st.sidebar.slider("Width", 200, 1500, 800, 100)
    height = st.sidebar.slider("Height", 200, 1500, 900, 100)
    st.components.v1.iframe(src, width, height, scrolling=True)

# query params exist
try:
    options = ['QCEngine', 'Grok', 'Playground', 'Circuit']
    query_params = st.experimental_get_query_params()
    query_option = query_params['option'][0] #throws an exception when visiting http://host:port
    option_selected = st.sidebar.selectbox('Pick option', options, index=options.index(query_option))
    if option_selected:
        st.experimental_set_query_params(option=option_selected)
        SetIframeURL(option_selected)

# run when query params don't exist. e.g on first launch
except: # catch exception and set query param to predefined value
    options = ['QCEngine', 'Grok', 'Playground', 'Circuit']
    st.experimental_set_query_params(option=options[1]) # defaults to dog
    query_params = st.experimental_get_query_params()
    query_option = query_params['option'][0]
    option_selected = st.sidebar.selectbox('Pick option', options, index=options.index(query_option))
    if option_selected:
        st.experimental_set_query_params(option=option_selected)
        SetIframeURL(option_selected)

def LoadGradioAIModels():
    title = "AI Quantum - QGAN and QCEngine"
    description = "Using Superposition Advantage from Quantum for QGAN AI."
    article = "<p style='text-align: center'></p>"

    examples = [
    ["Scientific breakthroughs in treatment of HIV/AIDS may be solved in our lifetime using a procedure called [MASK] modulation which strengthens the immune system to fight the disease."],["A disease called [MASK] disease involves progressive memory loss and has new treatments to improve memory and delay progression of the disease."],["[MASK] refers to the uncontrolled growth of abnormal cells in the body.  With chemotherapy and radiation therapy have improvements and replacements that destroy cancer cells before they become resistant to current treatment methods."],["The hereditary disease [MASK] is caused by mucus abnormally thick preventing lungs and pancreas from doing their jobs correctly."],["[MASK] or atherosclerosis is the buildup of cholesterol, fatty cells, and inflammatory deposits in the arteries.  Stem cells, mechanical devices, and lowering cholesterol and blood pressure levels are helping prevention."]]
