from transformers import BlenderbotTokenizer, BlenderbotForConditionalGeneration
import torch
import gradio as gr


# PersistDataset -----
import os
import csv
import gradio as gr
from gradio import inputs, outputs
import huggingface_hub
from huggingface_hub import Repository, hf_hub_download, upload_file
from datetime import datetime


# -------------------------------------------- For Memory - you will need to set up a dataset and HF_TOKEN ---------
#DATASET_REPO_URL = "https://huggingface.co/datasets/awacke1/ChatbotMemory.csv"
#DATASET_REPO_ID = "awacke1/ChatbotMemory.csv"
#DATA_FILENAME = "ChatbotMemory.csv"
#DATA_FILE = os.path.join("data", DATA_FILENAME)
#HF_TOKEN = os.environ.get("HF_TOKEN")

#SCRIPT = """
#<script>
#if (!window.hasBeenRun) {
#    window.hasBeenRun = true;
#    console.log("should only happen once");
#    document.querySelector("button.submit").click();
#}
#</script>
#"""

#try:
#    hf_hub_download(
#        repo_id=DATASET_REPO_ID,
#        filename=DATA_FILENAME,
#        cache_dir=DATA_DIRNAME,
#        force_filename=DATA_FILENAME
#    )
#except:
#    print("file not found")
#repo = Repository(
#    local_dir="data", clone_from=DATASET_REPO_URL, use_auth_token=HF_TOKEN
#)
            
#def store_message(name: str, message: str):
#    if name and message:
#        with open(DATA_FILE, "a") as csvfile:
#            writer = csv.DictWriter(csvfile, fieldnames=["name", "message", "time"])
#            writer.writerow(
#                {"name": name.strip(), "message": message.strip(), "time": str(datetime.now())}
#            )
# uncomment line below to begin saving.  If creating your own copy you will need to add a access token called "HF_TOKEN" to your profile, then create a secret for your repo with the access code naming it "HF_TOKEN"  For the CSV as well you can copy the header and first few lines to your own then update the paths above which should work to save to your own repository for datasets.    
#        commit_url = repo.push_to_hub()
#    return ""
    
#iface = gr.Interface(
#    store_message,
#    [
#        inputs.Textbox(placeholder="Your name"),
#        inputs.Textbox(placeholder="Your message", lines=2),
#    ],
#    "html",
#    css="""
#    .message {background-color:cornflowerblue;color:white; padding:4px;margin:4px;border-radius:4px; }
#    """,
#    title="Reading/writing to a HuggingFace dataset repo from Spaces",
#    description=f"This is a demo of how to do simple *shared data persistence* in a Gradio Space, backed by a dataset repo.",
#    article=f"The dataset repo is [{DATASET_REPO_URL}]({DATASET_REPO_URL})",
#)
# --------------------------------------------------- For Memory

mname = "facebook/blenderbot-400M-distill"
model = BlenderbotForConditionalGeneration.from_pretrained(mname)
tokenizer = BlenderbotTokenizer.from_pretrained(mname)

def take_last_tokens(inputs, note_history, history):
    """Filter the last 128 tokens"""
    if inputs['input_ids'].shape[1] > 128:
        inputs['input_ids'] = torch.tensor([inputs['input_ids'][0][-128:].tolist()])
        inputs['attention_mask'] = torch.tensor([inputs['attention_mask'][0][-128:].tolist()])
        note_history = ['</s> <s>'.join(note_history[0].split('</s> <s>')[2:])]
        history = history[1:]
    return inputs, note_history, history

def add_note_to_history(note, note_history):
    """Add a note to the historical information"""
    note_history.append(note)
    note_history = '</s> <s>'.join(note_history)
    return [note_history]

title = "State of the Art Chatbot with Memory Dataset"
description = """Chatbot With Memory"""

def chat(message, history):
    history = history or []
    if history: 
        history_useful = ['</s> <s>'.join([str(a[0])+'</s> <s>'+str(a[1]) for a in history])]
    else:
        history_useful = []
    history_useful = add_note_to_history(message, history_useful)
    inputs = tokenizer(history_useful, return_tensors="pt")
    inputs, history_useful, history = take_last_tokens(inputs, history_useful, history)
    reply_ids = model.generate(**inputs)
    response = tokenizer.batch_decode(reply_ids, skip_special_tokens=True)[0]
    history_useful = add_note_to_history(response, history_useful)
    list_history = history_useful[0].split('</s> <s>')
    history.append((list_history[-2], list_history[-1]))
#    store_message(message, response) # Save to dataset  -- uncomment with code above, create a dataset to store and add your HF_TOKEN from profile to this repo to use.
    return history, history

gr.Interface(
    fn=chat,
    theme="huggingface",
    css=".footer {display:none !important}",
    inputs=["text", "state"],
    outputs=["chatbot", "state"],
    title=title,
    allow_flagging="never",
    description=f"Gradio chatbot backed by memory in a dataset repository.",
#    article=f"The dataset repo is [{DATASET_REPO_URL}]({DATASET_REPO_URL})"
    ).launch(debug=True)
        
#demo = gr.Blocks()
#with demo:
#    audio_file = gr.inputs.Audio(source="microphone", type="filepath")
#    text = gr.Textbox(label="Speech to Text")
#    TTSchoice = gr.inputs.Radio( label="Pick a Text to Speech Model", choices=MODEL_NAMES,   )
#    audio = gr.Audio(label="Output", interactive=False)
#    b1 = gr.Button("Recognize Speech")
#    b5 = gr.Button("Read It Back Aloud")
#    b1.click(speech_to_text, inputs=audio_file, outputs=text)
#    b5.click(tts,  inputs=[text,TTSchoice], outputs=audio)    
#demo.launch(share=True)
