import gradio as gr
from summarize import Summarizer

interface = gr.Interface(fn = Summarizer,
                        inputs = [gr.inputs.Textbox(lines=2, 
                                                    placeholder="Enter your link...",
                                                    label='YouTube Video Link'),
                                  gr.inputs.Radio(["mT5", "BART"], type="value", label='Model')],
                        outputs = [gr.outputs.Textbox(
                                                      label="Summary")],
                         
                        title = "Video Summary Generator",
                        examples = [
                                   ['https://www.youtube.com/watch?v=cdiD-9MMpb0', 'BART'],
                                   ['https://www.youtube.com/watch?v=p3lsYlod5OU&t=5202s', 'BART'],
                                   ['https://www.youtube.com/watch?v=Gfr50f6ZBvo&t=1493s', 'BART'],
                                   ['https://www.youtube.com/watch?v=4oDZyOf6CW4&t=3149s', 'BART'],
                                   ['https://www.youtube.com/watch?v=lvh3g7eszVQ&t=291s', 'mT5'],
                                   ['https://www.youtube.com/watch?v=OaeYUm06in0', 'mT5'],
                                   ['https://www.youtube.com/watch?v=ZecQ64l-gKM&t=545s', 'mT5'],
                                   ['https://www.youtube.com/watch?v=5zOHSysMmH0&t=5798s', 'mT5'],
                                   ['https://www.youtube.com/watch?v=X0-SXS6zdEQ&t=23s', 'mT5'],
                                   ['https://www.youtube.com/watch?v=gFEE3w7F0ww&t=18s', 'mT5'],
                                   ['https://www.youtube.com/watch?v=Z1KwkpTUbkg&t=30s', 'mT5'],
                                   ['https://www.youtube.com/watch?v=rIpUf-Vy2JA&t=3542s', 'mT5'],
                                   ['https://www.youtube.com/watch?v=bgNzUxyS-kQ&t=3631s', 'mT5']
                                   ],
                        enable_queue=True)

interface.launch(debug=True) 