import{s as Xt,o as Yt,n as kt}from"../chunks/scheduler.8c3d61f6.js";import{S as Nt,i as Vt,g as o,s as i,r as f,A as Dt,h as l,f as n,c as a,j as W,u as h,x as c,k,y as p,a as s,v as u,d as g,t as y,w as _}from"../chunks/index.da70eac4.js";import{T as Rt}from"../chunks/Tip.1d9b8c37.js";import{D as _e}from"../chunks/Docstring.6b390b9a.js";import{C as Ke}from"../chunks/CodeBlock.00a903b3.js";import{E as $t}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as be,E as Ht}from"../chunks/EditOnGithub.1e64e623.js";function zt(ce){let r,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=o("p"),r.innerHTML=J},l(M){r=l(M,"P",{"data-svelte-h":!0}),c(r)!=="svelte-w7r39y"&&(r.innerHTML=J)},m(M,w){s(M,r,w)},p:kt,d(M){M&&n(r)}}}function Ft(ce){let r,J="Examples:",M,w,v;return w=new Ke({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install consisid_eva_clip insightface facexlib</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.pipelines.consisid.consisid_utils <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = (
<span class="hljs-meta">... </span>    prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#x27;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#x27;s path, adding depth to the scene. The lighting highlights the boy&#x27;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://github.com/PKU-YuanGroup/ConsisID/blob/main/asserts/example_images/2.png?raw=true&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(
<span class="hljs-meta">... </span>    face_helper_1,
<span class="hljs-meta">... </span>    face_clip_model,
<span class="hljs-meta">... </span>    face_helper_2,
<span class="hljs-meta">... </span>    eva_transform_mean,
<span class="hljs-meta">... </span>    eva_transform_std,
<span class="hljs-meta">... </span>    face_main_model,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    torch.bfloat16,
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    is_align_face=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,
<span class="hljs-meta">... </span>    use_dynamic_cfg=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    id_vit_hidden=id_vit_hidden,
<span class="hljs-meta">... </span>    id_cond=id_cond,
<span class="hljs-meta">... </span>    kps_cond=face_kps,
<span class="hljs-meta">... </span>    generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){r=o("p"),r.textContent=J,M=i(),f(w.$$.fragment)},l(d){r=l(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-kvfsh7"&&(r.textContent=J),M=a(d),h(w.$$.fragment,d)},m(d,T){s(d,r,T),s(d,M,T),u(w,d,T),v=!0},p:kt,i(d){v||(g(w.$$.fragment,d),v=!0)},o(d){y(w.$$.fragment,d),v=!1},d(d){d&&(n(r),n(M)),_(w,d)}}}function Pt(ce){let r,J,M,w,v,d,T,mt='<a href="https://arxiv.org/abs/2411.17440" rel="nofollow">Identity-Preserving Text-to-Video Generation by Frequency Decomposition</a> from Peking University &amp; University of Rochester &amp; etc, by Shenghai Yuan, Jinfa Huang, Xianyi He, Yunyang Ge, Yujun Shi, Liuhan Chen, Jiebo Luo, Li Yuan.',we,X,ft="The abstract from the paper is:",ve,Y,ht='<em>Identity-preserving text-to-video (IPT2V) generation aims to create high-fidelity videos with consistent human identity. It is an important task in video generation but remains an open problem for generative models. This paper pushes the technical frontier of IPT2V in two directions that have not been resolved in the literature: (1) A tuning-free pipeline without tedious case-by-case finetuning, and (2) A frequency-aware heuristic identity-preserving Diffusion Transformer (DiT)-based control scheme. To achieve these goals, we propose <strong>ConsisID</strong>, a tuning-free DiT-based controllable IPT2V model to keep human-<strong>id</strong>entity <strong>consis</strong>tent in the generated video. Inspired by prior findings in frequency analysis of vision/diffusion transformers, it employs identity-control signals in the frequency domain, where facial features can be decomposed into low-frequency global features (e.g., profile, proportions) and high-frequency intrinsic features (e.g., identity markers that remain unaffected by pose changes). First, from a low-frequency perspective, we introduce a global facial extractor, which encodes the reference image and facial key points into a latent space, generating features enriched with low-frequency information. These features are then integrated into the shallow layers of the network to alleviate training challenges associated with DiT. Second, from a high-frequency perspective, we design a local facial extractor to capture high-frequency details and inject them into the transformer blocks, enhancing the model’s ability to preserve fine-grained features. To leverage the frequency information for identity preservation, we propose a hierarchical training strategy, transforming a vanilla pre-trained video generation model into an IPT2V model. Extensive experiments demonstrate that our frequency-aware heuristic scheme provides an optimal control solution for DiT-based models. Thanks to this scheme, our <strong>ConsisID</strong> achieves excellent results in generating high-quality, identity-preserving videos, making strides towards more effective IPT2V. The model weight of ConsID is publicly available at <a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">https://github.com/PKU-YuanGroup/ConsisID</a>.</em>',Te,Z,Je,N,ut='This pipeline was contributed by <a href="https://github.com/SHYuanBest" rel="nofollow">SHYuanBest</a>. The original codebase can be found <a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/BestWishYsh" rel="nofollow">hf.co/BestWishYsh</a>.',Ie,V,gt="There are two official ConsisID checkpoints for identity-preserving text-to-video.",Ue,D,yt='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/BestWishYsh/ConsisID-preview" rel="nofollow"><code>BestWishYsh/ConsisID-preview</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/BestWishYsh/ConsisID-preview" rel="nofollow"><code>BestWishYsh/ConsisID-1.5</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',je,R,Ze,$,_t='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',Ge,H,bt="First, load the pipeline:",Ce,z,xe,F,Mt="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",Be,P,We,Q,wt="Compile the components and run inference:",ke,E,Xe,q,Ye,L,vt='ConsisID requires about 44 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/SHYuanBest/bc4207c36f454f9e969adbb50eaf8258" rel="nofollow">this</a> script.',Ne,S,Tt='<thead><tr><th align="left">Feature (overlay the previous)</th> <th align="left">Max Memory Allocated</th> <th align="left">Max Memory Reserved</th></tr></thead> <tbody><tr><td align="left">-</td> <td align="left">37 GB</td> <td align="left">44 GB</td></tr> <tr><td align="left">enable_model_cpu_offload</td> <td align="left">22 GB</td> <td align="left">25 GB</td></tr> <tr><td align="left">enable_sequential_cpu_offload</td> <td align="left">16 GB</td> <td align="left">22 GB</td></tr> <tr><td align="left">vae.enable_slicing</td> <td align="left">16 GB</td> <td align="left">22 GB</td></tr> <tr><td align="left">vae.enable_tiling</td> <td align="left">5 GB</td> <td align="left">7 GB</td></tr></tbody>',Ve,A,De,O,Jt='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> and <a href="https://github.com/huggingface/optimum-quanto/" rel="nofollow">optimum-quanto</a> can be used to quantize the text encoder, transformer and VAE modules to lower the memory requirements. This makes it possible to run the model on a free-tier T4 Colab or lower VRAM GPUs!',Re,K,It='It is also worth noting that torchao quantization is fully compatible with <a href="/optimization/torch2.0#torchcompile">torch.compile</a>, which allows for much faster inference speed. Additionally, models can be serialized and stored in a quantized datatype to save disk space with torchao. Find examples and benchmarks in the gists below.',$e,ee,Ut='<li><a href="https://gist.github.com/a-r-r-o-w/4d9732d17412888c885480c6521a9897" rel="nofollow">torchao</a></li> <li><a href="https://gist.github.com/a-r-r-o-w/31be62828b00a9292821b85c1017effa" rel="nofollow">quanto</a></li>',He,te,ze,m,ne,et,de,jt="Pipeline for image-to-video generation using ConsisID.",tt,me,Zt=`This model inherits from <a href="/docs/diffusers/pr_10140/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,nt,I,se,st,fe,Gt="Function invoked when calling the pipeline for generation.",it,G,at,C,ie,ot,he,Ct="Encodes the prompt into text encoder hidden states.",lt,x,ae,rt,ue,xt="Enables fused QKV projections.",pt,B,oe,ct,ge,Bt="Disable QKV projection fusion if enabled.",Fe,le,Pe,U,re,dt,ye,Wt="Output class for ConsisID pipelines.",Qe,pe,Ee,Me,qe;return v=new be({props:{title:"ConsisID",local:"consisid",headingTag:"h1"}}),Z=new Rt({props:{$$slots:{default:[zt]},$$scope:{ctx:ce}}}),R=new be({props:{title:"Inference",local:"inference",headingTag:"h2"}}),z=new Ke({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBjb25zaXNpZF9ldmFfY2xpcCUyMGluc2lnaHRmYWNlJTIwZmFjZXhsaWIlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBDb25zaXNJRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMuY29uc2lzaWQuY29uc2lzaWRfdXRpbHMlMjBpbXBvcnQlMjBwcmVwYXJlX2ZhY2VfbW9kZWxzJTJDJTIwcHJvY2Vzc19mYWNlX2VtYmVkZGluZ3NfaW5mZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiUyQyUyMGxvY2FsX2RpciUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiklMEFmYWNlX2hlbHBlcl8xJTJDJTIwZmFjZV9oZWxwZXJfMiUyQyUyMGZhY2VfY2xpcF9tb2RlbCUyQyUyMGZhY2VfbWFpbl9tb2RlbCUyQyUyMGV2YV90cmFuc2Zvcm1fbWVhbiUyQyUyMGV2YV90cmFuc2Zvcm1fc3RkJTIwJTNEJTIwcHJlcGFyZV9mYWNlX21vZGVscyglMjJCZXN0V2lzaFlzaCUyRkNvbnNpc0lELXByZXZpZXclMjIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwQ29uc2lzSURQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyQmVzdFdpc2hZc2glMkZDb25zaXNJRC1wcmV2aWV3JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-comment"># !pip install consisid_eva_clip insightface facexlib</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.consisid.consisid_utils <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)
face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)
pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)`,wrap:!1}}),P=new Ke({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),E=new Ke({props:{code:"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",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># ConsisID works well with long and well-described prompts and image contain clear face (e.g., preferably half-body or full-body).</span>
prompt = <span class="hljs-string">&quot;The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#x27;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#x27;s path, adding depth to the scene. The lighting highlights the boy&#x27;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.&quot;</span>
image = <span class="hljs-string">&quot;https://github.com/PKU-YuanGroup/ConsisID/blob/main/asserts/example_images/2.png?raw=true&quot;</span>

id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(face_helper_1, face_clip_model, face_helper_2, eva_transform_mean, eva_transform_std, face_main_model, <span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, image, is_align_face=<span class="hljs-literal">True</span>)

video = pipe(image=image, prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">6.0</span>, use_dynamic_cfg=<span class="hljs-literal">False</span>, id_vit_hidden=id_vit_hidden, id_cond=id_cond, kps_cond=face_kps, generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>))
export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),q=new be({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),A=new be({props:{title:"Quantized inference",local:"quantized-inference",headingTag:"h3"}}),te=new be({props:{title:"ConsisIDPipeline",local:"diffusers.ConsisIDPipeline",headingTag:"h2"}}),ne=new _e({props:{name:"class diffusers.ConsisIDPipeline",anchor:"diffusers.ConsisIDPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": ConsisIDTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10140/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.ConsisIDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. ConsisID uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.ConsisIDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.ConsisIDPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10140/en/api/models/consisid_transformer3d#diffusers.ConsisIDTransformer3DModel">ConsisIDTransformer3DModel</a>) &#x2014;
A text conditioned <code>ConsisIDTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.ConsisIDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10140/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L245"}}),se=new _e({props:{name:"__call__",anchor:"diffusers.ConsisIDPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 720"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"},{name:"id_vit_hidden",val:": typing.Optional[torch.Tensor] = None"},{name:"id_cond",val:": typing.Optional[torch.Tensor] = None"},{name:"kps_cond",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.ConsisIDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.ConsisIDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>49</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because ConsisID is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 4. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.ConsisIDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 6) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.ConsisIDPipeline.__call__.use_dynamic_cfg",description:`<strong>use_dynamic_cfg</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, dynamically adjusts the guidance scale during inference. This allows the model to use a
progressive guidance scale, improving the balance between text-guided generation and image quality over
the course of the inference steps. Typically, early inference steps use a higher guidance scale for
more faithful image generation, while later steps reduce it for more diverse and natural results.`,name:"use_dynamic_cfg"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.ConsisIDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.ConsisIDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.ConsisIDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.ConsisIDPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.ConsisIDPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.ConsisIDPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10140/en/api/pipelines/consisid#diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput"
>ConsisIDPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10140/en/api/pipelines/consisid#diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput"
>ConsisIDPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new $t({props:{anchor:"diffusers.ConsisIDPipeline.__call__.example",$$slots:{default:[Ft]},$$scope:{ctx:ce}}}),ie=new _e({props:{name:"encode_prompt",anchor:"diffusers.ConsisIDPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L350"}}),ae=new _e({props:{name:"fuse_qkv_projections",anchor:"diffusers.ConsisIDPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L616"}}),oe=new _e({props:{name:"unfuse_qkv_projections",anchor:"diffusers.ConsisIDPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L622"}}),le=new be({props:{title:"ConsisIDPipelineOutput",local:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",headingTag:"h2"}}),re=new _e({props:{name:"class diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",anchor:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_output.py#L8"}}),pe=new Ht({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/consisid.md"}}),{c(){r=o("meta"),J=i(),M=o("p"),w=i(),f(v.$$.fragment),d=i(),T=o("p"),T.innerHTML=mt,we=i(),X=o("p"),X.textContent=ft,ve=i(),Y=o("p"),Y.innerHTML=ht,Te=i(),f(Z.$$.fragment),Je=i(),N=o("p"),N.innerHTML=ut,Ie=i(),V=o("p"),V.textContent=gt,Ue=i(),D=o("table"),D.innerHTML=yt,je=i(),f(R.$$.fragment),Ze=i(),$=o("p"),$.innerHTML=_t,Ge=i(),H=o("p"),H.textContent=bt,Ce=i(),f(z.$$.fragment),xe=i(),F=o("p"),F.innerHTML=Mt,Be=i(),f(P.$$.fragment),We=i(),Q=o("p"),Q.textContent=wt,ke=i(),f(E.$$.fragment),Xe=i(),f(q.$$.fragment),Ye=i(),L=o("p"),L.innerHTML=vt,Ne=i(),S=o("table"),S.innerHTML=Tt,Ve=i(),f(A.$$.fragment),De=i(),O=o("p"),O.innerHTML=Jt,Re=i(),K=o("p"),K.innerHTML=It,$e=i(),ee=o("ul"),ee.innerHTML=Ut,He=i(),f(te.$$.fragment),ze=i(),m=o("div"),f(ne.$$.fragment),et=i(),de=o("p"),de.textContent=jt,tt=i(),me=o("p"),me.innerHTML=Zt,nt=i(),I=o("div"),f(se.$$.fragment),st=i(),fe=o("p"),fe.textContent=Gt,it=i(),f(G.$$.fragment),at=i(),C=o("div"),f(ie.$$.fragment),ot=i(),he=o("p"),he.textContent=Ct,lt=i(),x=o("div"),f(ae.$$.fragment),rt=i(),ue=o("p"),ue.textContent=xt,pt=i(),B=o("div"),f(oe.$$.fragment),ct=i(),ge=o("p"),ge.textContent=Bt,Fe=i(),f(le.$$.fragment),Pe=i(),U=o("div"),f(re.$$.fragment),dt=i(),ye=o("p"),ye.textContent=Wt,Qe=i(),f(pe.$$.fragment),Ee=i(),Me=o("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(n),J=a(e),M=l(e,"P",{}),W(M).forEach(n),w=a(e),h(v.$$.fragment,e),d=a(e),T=l(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-18faaze"&&(T.innerHTML=mt),we=a(e),X=l(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1cwsb16"&&(X.textContent=ft),ve=a(e),Y=l(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-16o3b9f"&&(Y.innerHTML=ht),Te=a(e),h(Z.$$.fragment,e),Je=a(e),N=l(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-508pas"&&(N.innerHTML=ut),Ie=a(e),V=l(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-10ua0j4"&&(V.textContent=gt),Ue=a(e),D=l(e,"TABLE",{"data-svelte-h":!0}),c(D)!=="svelte-1g40pp0"&&(D.innerHTML=yt),je=a(e),h(R.$$.fragment,e),Ze=a(e),$=l(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-iekg51"&&($.innerHTML=_t),Ge=a(e),H=l(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-jub7f1"&&(H.textContent=bt),Ce=a(e),h(z.$$.fragment,e),xe=a(e),F=l(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1p91erm"&&(F.innerHTML=Mt),Be=a(e),h(P.$$.fragment,e),We=a(e),Q=l(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-oyjtrh"&&(Q.textContent=wt),ke=a(e),h(E.$$.fragment,e),Xe=a(e),h(q.$$.fragment,e),Ye=a(e),L=l(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-l3wq5l"&&(L.innerHTML=vt),Ne=a(e),S=l(e,"TABLE",{"data-svelte-h":!0}),c(S)!=="svelte-i2ot8w"&&(S.innerHTML=Tt),Ve=a(e),h(A.$$.fragment,e),De=a(e),O=l(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1elq2ob"&&(O.innerHTML=Jt),Re=a(e),K=l(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-9tb0fb"&&(K.innerHTML=It),$e=a(e),ee=l(e,"UL",{"data-svelte-h":!0}),c(ee)!=="svelte-190pde7"&&(ee.innerHTML=Ut),He=a(e),h(te.$$.fragment,e),ze=a(e),m=l(e,"DIV",{class:!0});var b=W(m);h(ne.$$.fragment,b),et=a(b),de=l(b,"P",{"data-svelte-h":!0}),c(de)!=="svelte-1ypyl48"&&(de.textContent=jt),tt=a(b),me=l(b,"P",{"data-svelte-h":!0}),c(me)!=="svelte-12lopph"&&(me.innerHTML=Zt),nt=a(b),I=l(b,"DIV",{class:!0});var j=W(I);h(se.$$.fragment,j),st=a(j),fe=l(j,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-v78lg8"&&(fe.textContent=Gt),it=a(j),h(G.$$.fragment,j),j.forEach(n),at=a(b),C=l(b,"DIV",{class:!0});var Le=W(C);h(ie.$$.fragment,Le),ot=a(Le),he=l(Le,"P",{"data-svelte-h":!0}),c(he)!=="svelte-16q0ax1"&&(he.textContent=Ct),Le.forEach(n),lt=a(b),x=l(b,"DIV",{class:!0});var Se=W(x);h(ae.$$.fragment,Se),rt=a(Se),ue=l(Se,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1vadzv1"&&(ue.textContent=xt),Se.forEach(n),pt=a(b),B=l(b,"DIV",{class:!0});var Ae=W(B);h(oe.$$.fragment,Ae),ct=a(Ae),ge=l(Ae,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-fohozp"&&(ge.textContent=Bt),Ae.forEach(n),b.forEach(n),Fe=a(e),h(le.$$.fragment,e),Pe=a(e),U=l(e,"DIV",{class:!0});var Oe=W(U);h(re.$$.fragment,Oe),dt=a(Oe),ye=l(Oe,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-ihv7pb"&&(ye.textContent=Wt),Oe.forEach(n),Qe=a(e),h(pe.$$.fragment,e),Ee=a(e),Me=l(e,"P",{}),W(Me).forEach(n),this.h()},h(){k(r,"name","hf:doc:metadata"),k(r,"content",Qt),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,r),s(e,J,t),s(e,M,t),s(e,w,t),u(v,e,t),s(e,d,t),s(e,T,t),s(e,we,t),s(e,X,t),s(e,ve,t),s(e,Y,t),s(e,Te,t),u(Z,e,t),s(e,Je,t),s(e,N,t),s(e,Ie,t),s(e,V,t),s(e,Ue,t),s(e,D,t),s(e,je,t),u(R,e,t),s(e,Ze,t),s(e,$,t),s(e,Ge,t),s(e,H,t),s(e,Ce,t),u(z,e,t),s(e,xe,t),s(e,F,t),s(e,Be,t),u(P,e,t),s(e,We,t),s(e,Q,t),s(e,ke,t),u(E,e,t),s(e,Xe,t),u(q,e,t),s(e,Ye,t),s(e,L,t),s(e,Ne,t),s(e,S,t),s(e,Ve,t),u(A,e,t),s(e,De,t),s(e,O,t),s(e,Re,t),s(e,K,t),s(e,$e,t),s(e,ee,t),s(e,He,t),u(te,e,t),s(e,ze,t),s(e,m,t),u(ne,m,null),p(m,et),p(m,de),p(m,tt),p(m,me),p(m,nt),p(m,I),u(se,I,null),p(I,st),p(I,fe),p(I,it),u(G,I,null),p(m,at),p(m,C),u(ie,C,null),p(C,ot),p(C,he),p(m,lt),p(m,x),u(ae,x,null),p(x,rt),p(x,ue),p(m,pt),p(m,B),u(oe,B,null),p(B,ct),p(B,ge),s(e,Fe,t),u(le,e,t),s(e,Pe,t),s(e,U,t),u(re,U,null),p(U,dt),p(U,ye),s(e,Qe,t),u(pe,e,t),s(e,Ee,t),s(e,Me,t),qe=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),Z.$set(b);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),G.$set(j)},i(e){qe||(g(v.$$.fragment,e),g(Z.$$.fragment,e),g(R.$$.fragment,e),g(z.$$.fragment,e),g(P.$$.fragment,e),g(E.$$.fragment,e),g(q.$$.fragment,e),g(A.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(G.$$.fragment,e),g(ie.$$.fragment,e),g(ae.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(re.$$.fragment,e),g(pe.$$.fragment,e),qe=!0)},o(e){y(v.$$.fragment,e),y(Z.$$.fragment,e),y(R.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(E.$$.fragment,e),y(q.$$.fragment,e),y(A.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(G.$$.fragment,e),y(ie.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(le.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),qe=!1},d(e){e&&(n(J),n(M),n(w),n(d),n(T),n(we),n(X),n(ve),n(Y),n(Te),n(Je),n(N),n(Ie),n(V),n(Ue),n(D),n(je),n(Ze),n($),n(Ge),n(H),n(Ce),n(xe),n(F),n(Be),n(We),n(Q),n(ke),n(Xe),n(Ye),n(L),n(Ne),n(S),n(Ve),n(De),n(O),n(Re),n(K),n($e),n(ee),n(He),n(ze),n(m),n(Fe),n(Pe),n(U),n(Qe),n(Ee),n(Me)),n(r),_(v,e),_(Z,e),_(R,e),_(z,e),_(P,e),_(E,e),_(q,e),_(A,e),_(te,e),_(ne),_(se),_(G),_(ie),_(ae),_(oe),_(le,e),_(re),_(pe,e)}}}const Qt='{"title":"ConsisID","local":"consisid","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3},{"title":"Quantized inference","local":"quantized-inference","sections":[],"depth":3}],"depth":2},{"title":"ConsisIDPipeline","local":"diffusers.ConsisIDPipeline","sections":[],"depth":2},{"title":"ConsisIDPipelineOutput","local":"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput","sections":[],"depth":2}],"depth":1}';function Et(ce){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tn extends Nt{constructor(r){super(),Vt(this,r,Et,Pt,Xt,{})}}export{tn as component};
