import{s as de,n as pe,o as me}from"../chunks/scheduler.8c3d61f6.js";import{S as he,i as ye,g as n,s as l,r as G,A as ue,h as o,f as s,c as i,j as oe,u as j,x as r,k as ce,y as Me,a,v,d as I,t as B,w as W}from"../chunks/index.da70eac4.js";import{C as re}from"../chunks/CodeBlock.00a903b3.js";import{H as A,E as fe}from"../chunks/EditOnGithub.1e64e623.js";function be(K){let c,Y,X,R,d,k,p,O='<a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">ConsisID</a> is an identity-preserving text-to-video generation model that keeps the face consistent in the generated video by frequency decomposition. The main features of ConsisID are:',x,m,ee="<li>Frequency decomposition: The characteristics of the DiT architecture are analyzed from the frequency domain perspective, and based on these characteristics, a reasonable control information injection method is designed.</li> <li>Consistency training strategy: A coarse-to-fine training strategy, dynamic masking loss, and dynamic cross-face loss further enhance the model’s generalization ability and identity preservation performance.</li> <li>Inference without finetuning: Previous methods required case-by-case finetuning of the input ID before inference, leading to significant time and computational costs. In contrast, ConsisID is tuning-free.</li>",V,h,te="This guide will walk you through using ConsisID for use cases.",C,y,N,u,se='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/pr_10140/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',H,M,Q,f,$,b,ae="For identity-preserving text-to-video, pass a text prompt and an image contain clear face (e.g., preferably half-body or full-body). By default, ConsisID generates a 720x480 video for the best results.",F,w,z,J,le='<tbody><tr><th style="text-align: center;">Face Image</th> <th style="text-align: center;">Video</th> <th style="text-align: center;">Description</th> </tr><tr><td><img src="https://github.com/user-attachments/assets/be0257b5-9d90-47ba-93f4-5faf78fd1859" style="height: auto; width: 600px;"/></td> <td><img src="https://github.com/user-attachments/assets/f0e2803c-7214-4463-afd8-b28c0cd87c64" style="height: auto; width: 2000px;"/></td> <td>The video features a woman in exquisite hybrid armor adorned with iridescent gemstones, standing amidst gently falling cherry blossoms. Her piercing yet serene gaze hints at quiet determination, as a breeze catches a loose strand of her hair ......</td></tr> <tr><td><img src="https://github.com/user-attachments/assets/c1418804-3e5b-4f8b-87f1-25d4ddeee99e" style="height: auto; width: 600px;"/></td> <td><img src="https://github.com/user-attachments/assets/3491e75c-e01a-41d3-ae01-0c2535b7fa81" style="height: auto; width: 2000px;"/></td> <td>The video features a baby wearing a bright superhero cape, standing confidently with arms raised in a powerful pose. The baby has a determined look on their face, with eyes wide and lips pursed in concentration, as if ready to take on a challenge ......</td></tr> <tr><td><img src="https://github.com/user-attachments/assets/2c4ea113-47cd-4295-b643-a10e2a566823" style="height: auto; width: 600px;"/></td> <td><img src="https://github.com/user-attachments/assets/2ffb154f-23dc-4314-9976-95c0bd16810b" style="height: auto; width: 2000px;;"/></td> <td>The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#39;s lost in contemplation. The film grain adds a textured ......</td></tr> <tr><td><img src="https://github.com/user-attachments/assets/d48cb0be-0a64-40fa-8f86-ac406548d592" style="height: auto; width: 600px;"/></td> <td><img src="https://github.com/user-attachments/assets/9eb298a3-4c2a-407e-b73b-32f88895df22" style="height: auto; width: 2000px;;"/></td> <td>The video features a man standing at an easel, focused intently as his brush dances across the canvas. His expression is one of deep concentration, with a hint of satisfaction as each brushstroke adds color and form ......</td></tr></tbody>',E,T,D,g,ie="Learn more about ConsisID with the following resources.",q,Z,ne='<li>A <a href="https://www.youtube.com/watch?v=PhlgC-bI5SQ" rel="nofollow">video</a> demonstrating ConsisID’s main features.</li> <li>The research paper, <a href="https://hf.co/papers/2411.17440" rel="nofollow">Identity-Preserving Text-to-Video Generation by Frequency Decomposition</a> for more details.</li>',L,U,S,_,P;return d=new A({props:{title:"ConsisID",local:"consisid",headingTag:"h1"}}),y=new A({props:{title:"Load Model Checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),M=new re({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBjb25zaXNpZF9ldmFfY2xpcCUyMGluc2lnaHRmYWNlJTIwZmFjZXhsaWIlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBDb25zaXNJRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMuY29uc2lzaWQuY29uc2lzaWRfdXRpbHMlMjBpbXBvcnQlMjBwcmVwYXJlX2ZhY2VfbW9kZWxzJTJDJTIwcHJvY2Vzc19mYWNlX2VtYmVkZGluZ3NfaW5mZXIlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwc25hcHNob3RfZG93bmxvYWQlMEElMEElMjMlMjBEb3dubG9hZCUyMGNrcHRzJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiUyQyUyMGxvY2FsX2RpciUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiklMEElMEElMjMlMjBMb2FkJTIwZmFjZSUyMGhlbHBlciUyMG1vZGVsJTIwdG8lMjBwcmVwcm9jZXNzJTIwaW5wdXQlMjBmYWNlJTIwaW1hZ2UlMEFmYWNlX2hlbHBlcl8xJTJDJTIwZmFjZV9oZWxwZXJfMiUyQyUyMGZhY2VfY2xpcF9tb2RlbCUyQyUyMGZhY2VfbWFpbl9tb2RlbCUyQyUyMGV2YV90cmFuc2Zvcm1fbWVhbiUyQyUyMGV2YV90cmFuc2Zvcm1fc3RkJTIwJTNEJTIwcHJlcGFyZV9mYWNlX21vZGVscyglMjJCZXN0V2lzaFlzaCUyRkNvbnNpc0lELXByZXZpZXclMjIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEElMEElMjMlMjBMb2FkJTIwY29uc2lzaWQlMjBiYXNlJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwQ29uc2lzSURQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyQmVzdFdpc2hZc2glMkZDb25zaXNJRC1wcmV2aWV3JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-comment"># !pip install consisid_eva_clip insightface facexlib</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.consisid.consisid_utils <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

<span class="hljs-comment"># Download ckpts</span>
snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)

<span class="hljs-comment"># Load face helper model to preprocess input face image</span>
face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-comment"># Load consisid base model</span>
pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),f=new A({props:{title:"Identity-Preserving Text-to-Video",local:"identity-preserving-text-to-video",headingTag:"h2"}}),w=new re({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

prompt = <span class="hljs-string">&quot;The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#x27;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#x27;s path, adding depth to the scene. The lighting highlights the boy&#x27;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.&quot;</span>
image = <span class="hljs-string">&quot;https://github.com/PKU-YuanGroup/ConsisID/blob/main/asserts/example_images/2.png?raw=true&quot;</span>

id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(face_helper_1, face_clip_model, face_helper_2, eva_transform_mean, eva_transform_std, face_main_model, <span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, image, is_align_face=<span class="hljs-literal">True</span>)

video = pipe(image=image, prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">6.0</span>, use_dynamic_cfg=<span class="hljs-literal">False</span>, id_vit_hidden=id_vit_hidden, id_cond=id_cond, kps_cond=face_kps, generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>))
export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),T=new A({props:{title:"Resources",local:"resources",headingTag:"h2"}}),U=new fe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/consisid.md"}}),{c(){c=n("meta"),Y=l(),X=n("p"),R=l(),G(d.$$.fragment),k=l(),p=n("p"),p.innerHTML=O,x=l(),m=n("ul"),m.innerHTML=ee,V=l(),h=n("p"),h.textContent=te,C=l(),G(y.$$.fragment),N=l(),u=n("p"),u.innerHTML=se,H=l(),G(M.$$.fragment),Q=l(),G(f.$$.fragment),$=l(),b=n("p"),b.textContent=ae,F=l(),G(w.$$.fragment),z=l(),J=n("table"),J.innerHTML=le,E=l(),G(T.$$.fragment),D=l(),g=n("p"),g.textContent=ie,q=l(),Z=n("ul"),Z.innerHTML=ne,L=l(),G(U.$$.fragment),S=l(),_=n("p"),this.h()},l(e){const t=ue("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(s),Y=i(e),X=o(e,"P",{}),oe(X).forEach(s),R=i(e),j(d.$$.fragment,e),k=i(e),p=o(e,"P",{"data-svelte-h":!0}),r(p)!=="svelte-436irt"&&(p.innerHTML=O),x=i(e),m=o(e,"UL",{"data-svelte-h":!0}),r(m)!=="svelte-14veasm"&&(m.innerHTML=ee),V=i(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1msmrce"&&(h.textContent=te),C=i(e),j(y.$$.fragment,e),N=i(e),u=o(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-dmxz4r"&&(u.innerHTML=se),H=i(e),j(M.$$.fragment,e),Q=i(e),j(f.$$.fragment,e),$=i(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1bshl1z"&&(b.textContent=ae),F=i(e),j(w.$$.fragment,e),z=i(e),J=o(e,"TABLE",{"data-svelte-h":!0}),r(J)!=="svelte-6mbi5k"&&(J.innerHTML=le),E=i(e),j(T.$$.fragment,e),D=i(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1qlvco3"&&(g.textContent=ie),q=i(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-169u4r5"&&(Z.innerHTML=ne),L=i(e),j(U.$$.fragment,e),S=i(e),_=o(e,"P",{}),oe(_).forEach(s),this.h()},h(){ce(c,"name","hf:doc:metadata"),ce(c,"content",we)},m(e,t){Me(document.head,c),a(e,Y,t),a(e,X,t),a(e,R,t),v(d,e,t),a(e,k,t),a(e,p,t),a(e,x,t),a(e,m,t),a(e,V,t),a(e,h,t),a(e,C,t),v(y,e,t),a(e,N,t),a(e,u,t),a(e,H,t),v(M,e,t),a(e,Q,t),v(f,e,t),a(e,$,t),a(e,b,t),a(e,F,t),v(w,e,t),a(e,z,t),a(e,J,t),a(e,E,t),v(T,e,t),a(e,D,t),a(e,g,t),a(e,q,t),a(e,Z,t),a(e,L,t),v(U,e,t),a(e,S,t),a(e,_,t),P=!0},p:pe,i(e){P||(I(d.$$.fragment,e),I(y.$$.fragment,e),I(M.$$.fragment,e),I(f.$$.fragment,e),I(w.$$.fragment,e),I(T.$$.fragment,e),I(U.$$.fragment,e),P=!0)},o(e){B(d.$$.fragment,e),B(y.$$.fragment,e),B(M.$$.fragment,e),B(f.$$.fragment,e),B(w.$$.fragment,e),B(T.$$.fragment,e),B(U.$$.fragment,e),P=!1},d(e){e&&(s(Y),s(X),s(R),s(k),s(p),s(x),s(m),s(V),s(h),s(C),s(N),s(u),s(H),s(Q),s($),s(b),s(F),s(z),s(J),s(E),s(D),s(g),s(q),s(Z),s(L),s(S),s(_)),s(c),W(d,e),W(y,e),W(M,e),W(f,e),W(w,e),W(T,e),W(U,e)}}}const we='{"title":"ConsisID","local":"consisid","sections":[{"title":"Load Model Checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Identity-Preserving Text-to-Video","local":"identity-preserving-text-to-video","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Je(K){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ge extends he{constructor(c){super(),ye(this,c,Je,be,de,{})}}export{Ge as component};
