import{s as dt,o as ft,n as ge}from"../chunks/scheduler.8c3d61f6.js";import{S as mt,i as ut,g as c,s as r,r as b,A as gt,h as d,f as a,c as p,j as D,u as w,x as T,k,y as o,a as m,v as y,d as v,t as $,w as x}from"../chunks/index.da70eac4.js";import{T as qe}from"../chunks/Tip.1d9b8c37.js";import{D as E}from"../chunks/Docstring.6b390b9a.js";import{C as He}from"../chunks/CodeBlock.00a903b3.js";import{E as Ye}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Oe,E as ht}from"../chunks/EditOnGithub.1e64e623.js";function _t(U){let n,_='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',i,s,u='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=c("p"),n.innerHTML=_,i=r(),s=c("p"),s.innerHTML=u},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1j961ct"&&(n.innerHTML=_),i=p(t),s=d(t,"P",{"data-svelte-h":!0}),T(s)!=="svelte-z4pn9c"&&(s.innerHTML=u)},m(t,h){m(t,n,h),m(t,i,h),m(t,s,h)},p:ge,d(t){t&&(a(n),a(i),a(s))}}}function bt(U){let n,_="Examples:",i,s,u;return s=new He({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teDQtdXBzY2FsZXIlMjIlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwbGV0J3MlMjBkb3dubG9hZCUyMGFuJTIwJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2QyLXVwc2NhbGUlMkZsb3dfcmVzX2NhdC5wbmclMjIlMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBbG93X3Jlc19pbWclMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWxvd19yZXNfaW1nJTIwJTNEJTIwbG93X3Jlc19pbWcucmVzaXplKCgxMjglMkMlMjAxMjgpKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjB3aGl0ZSUyMGNhdCUyMiUwQSUwQXVwc2NhbGVkX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rsb3dfcmVzX2ltZykuaW1hZ2VzJTVCMCU1RCUwQXVwc2NhbGVkX2ltYWdlLnNhdmUoJTIydXBzYW1wbGVkX2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model and scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionUpscalePipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an  image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd2-upscale/low_res_cat.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = low_res_img.resize((<span class="hljs-number">128</span>, <span class="hljs-number">128</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a white cat&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = pipeline(prompt=prompt, image=low_res_img).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;upsampled_cat.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,i=r(),b(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),i=p(t),w(s.$$.fragment,t)},m(t,h){m(t,n,h),m(t,i,h),y(s,t,h),u=!0},p:ge,i(t){u||(v(s.$$.fragment,t),u=!0)},o(t){$(s.$$.fragment,t),u=!1},d(t){t&&(a(n),a(i)),x(s,t)}}}function wt(U){let n,_=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=c("p"),n.innerHTML=_},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-ackzsn"&&(n.innerHTML=_)},m(i,s){m(i,n,s)},p:ge,d(i){i&&a(n)}}}function yt(U){let n,_="Examples:",i,s,u;return s=new He({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,i=r(),b(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),i=p(t),w(s.$$.fragment,t)},m(t,h){m(t,n,h),m(t,i,h),y(s,t,h),u=!0},p:ge,i(t){u||(v(s.$$.fragment,t),u=!0)},o(t){$(s.$$.fragment,t),u=!1},d(t){t&&(a(n),a(i)),x(s,t)}}}function vt(U){let n,_=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=c("p"),n.textContent=_},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-17p1lpg"&&(n.textContent=_)},m(i,s){m(i,n,s)},p:ge,d(i){i&&a(n)}}}function $t(U){let n,_="Examples:",i,s,u;return s=new He({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,i=r(),b(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),i=p(t),w(s.$$.fragment,t)},m(t,h){m(t,n,h),m(t,i,h),y(s,t,h),u=!0},p:ge,i(t){u||(v(s.$$.fragment,t),u=!0)},o(t){$(s.$$.fragment,t),u=!1},d(t){t&&(a(n),a(i)),x(s,t)}}}function xt(U){let n,_,i,s,u,t,h,Ke='The Stable Diffusion upscaler diffusion model was created by the researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. It is used to enhance the resolution of input images by a factor of 4.',_e,Z,be,R,we,f,A,Ie,oe,et="Pipeline for text-guided image super-resolution using Stable Diffusion 2.",Je,ae,tt=`This model inherits from <a href="/docs/diffusers/pr_10011/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Pe,ie,nt="The pipeline also inherits the following loading methods:",Se,le,st='<li><a href="/docs/diffusers/pr_10011/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_10011/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_10011/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_10011/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',De,S,F,ke,re,ot="The call function to the pipeline for generation.",je,G,Ce,M,Q,Ze,pe,at=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ge,L,Le,W,We,N,q,Ne,ce,it=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Ve,I,Y,Xe,de,lt=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Be,V,ze,X,Ee,B,O,Re,fe,rt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ae,z,H,Fe,me,pt="Encodes the prompt into text encoder hidden states.",ye,K,ve,j,ee,Qe,ue,ct="Output class for Stable Diffusion pipelines.",$e,te,xe,he,Te;return u=new Oe({props:{title:"Super-resolution",local:"super-resolution",headingTag:"h1"}}),Z=new qe({props:{$$slots:{default:[_t]},$$scope:{ctx:U}}}),R=new Oe({props:{title:"StableDiffusionUpscalePipeline",local:"diffusers.StableDiffusionUpscalePipeline",headingTag:"h2"}}),A=new E({props:{name:"class diffusers.StableDiffusionUpscalePipeline",anchor:"diffusers.StableDiffusionUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"low_res_scheduler",val:": DDPMScheduler"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": typing.Optional[typing.Any] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.image_processing_clip.CLIPImageProcessor] = None"},{name:"watermarker",val:": typing.Optional[typing.Any] = None"},{name:"max_noise_level",val:": int = 350"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10011/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_10011/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionUpscalePipeline.low_res_scheduler",description:`<strong>low_res_scheduler</strong> (<a href="/docs/diffusers/pr_10011/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler used to add initial noise to the low resolution conditioning image. It must be an instance of
<a href="/docs/diffusers/pr_10011/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>.`,name:"low_res_scheduler"},{anchor:"diffusers.StableDiffusionUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10011/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_10011/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_10011/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_10011/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L68"}}),F=new E({props:{name:"__call__",anchor:"diffusers.StableDiffusionUpscalePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"noise_level",val:": int = 20"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled.`,name:"image"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_10011/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10011/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L534",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_10011/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10011/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new Ye({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.example",$$slots:{default:[bt]},$$scope:{ctx:U}}}),Q=new E({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/pipeline_utils.py#L1663"}}),L=new qe({props:{warning:!0,$$slots:{default:[wt]},$$scope:{ctx:U}}}),W=new Ye({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[yt]},$$scope:{ctx:U}}}),q=new E({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/pipeline_utils.py#L1703"}}),Y=new E({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/pipeline_utils.py#L1602"}}),V=new qe({props:{warning:!0,$$slots:{default:[vt]},$$scope:{ctx:U}}}),X=new Ye({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[$t]},$$scope:{ctx:U}}}),O=new E({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/pipeline_utils.py#L1637"}}),H=new E({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L207"}}),K=new Oe({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ee=new E({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),te=new ht({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/upscale.md"}}),{c(){n=c("meta"),_=r(),i=c("p"),s=r(),b(u.$$.fragment),t=r(),h=c("p"),h.innerHTML=Ke,_e=r(),b(Z.$$.fragment),be=r(),b(R.$$.fragment),we=r(),f=c("div"),b(A.$$.fragment),Ie=r(),oe=c("p"),oe.textContent=et,Je=r(),ae=c("p"),ae.innerHTML=tt,Pe=r(),ie=c("p"),ie.textContent=nt,Se=r(),le=c("ul"),le.innerHTML=st,De=r(),S=c("div"),b(F.$$.fragment),ke=r(),re=c("p"),re.textContent=ot,je=r(),b(G.$$.fragment),Ce=r(),M=c("div"),b(Q.$$.fragment),Ze=r(),pe=c("p"),pe.textContent=at,Ge=r(),b(L.$$.fragment),Le=r(),b(W.$$.fragment),We=r(),N=c("div"),b(q.$$.fragment),Ne=r(),ce=c("p"),ce.innerHTML=it,Ve=r(),I=c("div"),b(Y.$$.fragment),Xe=r(),de=c("p"),de.innerHTML=lt,Be=r(),b(V.$$.fragment),ze=r(),b(X.$$.fragment),Ee=r(),B=c("div"),b(O.$$.fragment),Re=r(),fe=c("p"),fe.innerHTML=rt,Ae=r(),z=c("div"),b(H.$$.fragment),Fe=r(),me=c("p"),me.textContent=pt,ye=r(),b(K.$$.fragment),ve=r(),j=c("div"),b(ee.$$.fragment),Qe=r(),ue=c("p"),ue.textContent=ct,$e=r(),b(te.$$.fragment),xe=r(),he=c("p"),this.h()},l(e){const l=gt("svelte-u9bgzb",document.head);n=d(l,"META",{name:!0,content:!0}),l.forEach(a),_=p(e),i=d(e,"P",{}),D(i).forEach(a),s=p(e),w(u.$$.fragment,e),t=p(e),h=d(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1rmru20"&&(h.innerHTML=Ke),_e=p(e),w(Z.$$.fragment,e),be=p(e),w(R.$$.fragment,e),we=p(e),f=d(e,"DIV",{class:!0});var g=D(f);w(A.$$.fragment,g),Ie=p(g),oe=d(g,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-gmgvzq"&&(oe.textContent=et),Je=p(g),ae=d(g,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-m5bs7f"&&(ae.innerHTML=tt),Pe=p(g),ie=d(g,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-14s6m4u"&&(ie.textContent=nt),Se=p(g),le=d(g,"UL",{"data-svelte-h":!0}),T(le)!=="svelte-1iir06n"&&(le.innerHTML=st),De=p(g),S=d(g,"DIV",{class:!0});var C=D(S);w(F.$$.fragment,C),ke=p(C),re=d(C,"P",{"data-svelte-h":!0}),T(re)!=="svelte-50j04k"&&(re.textContent=ot),je=p(C),w(G.$$.fragment,C),C.forEach(a),Ce=p(g),M=d(g,"DIV",{class:!0});var J=D(M);w(Q.$$.fragment,J),Ze=p(J),pe=d(J,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-10jaql7"&&(pe.textContent=at),Ge=p(J),w(L.$$.fragment,J),Le=p(J),w(W.$$.fragment,J),J.forEach(a),We=p(g),N=d(g,"DIV",{class:!0});var ne=D(N);w(q.$$.fragment,ne),Ne=p(ne),ce=d(ne,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-1lh0nh5"&&(ce.innerHTML=it),ne.forEach(a),Ve=p(g),I=d(g,"DIV",{class:!0});var P=D(I);w(Y.$$.fragment,P),Xe=p(P),de=d(P,"P",{"data-svelte-h":!0}),T(de)!=="svelte-e03q3e"&&(de.innerHTML=lt),Be=p(P),w(V.$$.fragment,P),ze=p(P),w(X.$$.fragment,P),P.forEach(a),Ee=p(g),B=d(g,"DIV",{class:!0});var se=D(B);w(O.$$.fragment,se),Re=p(se),fe=d(se,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1vfte1e"&&(fe.innerHTML=rt),se.forEach(a),Ae=p(g),z=d(g,"DIV",{class:!0});var Ue=D(z);w(H.$$.fragment,Ue),Fe=p(Ue),me=d(Ue,"P",{"data-svelte-h":!0}),T(me)!=="svelte-16q0ax1"&&(me.textContent=pt),Ue.forEach(a),g.forEach(a),ye=p(e),w(K.$$.fragment,e),ve=p(e),j=d(e,"DIV",{class:!0});var Me=D(j);w(ee.$$.fragment,Me),Qe=p(Me),ue=d(Me,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1qpjiuf"&&(ue.textContent=ct),Me.forEach(a),$e=p(e),w(te.$$.fragment,e),xe=p(e),he=d(e,"P",{}),D(he).forEach(a),this.h()},h(){k(n,"name","hf:doc:metadata"),k(n,"content",Tt),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){o(document.head,n),m(e,_,l),m(e,i,l),m(e,s,l),y(u,e,l),m(e,t,l),m(e,h,l),m(e,_e,l),y(Z,e,l),m(e,be,l),y(R,e,l),m(e,we,l),m(e,f,l),y(A,f,null),o(f,Ie),o(f,oe),o(f,Je),o(f,ae),o(f,Pe),o(f,ie),o(f,Se),o(f,le),o(f,De),o(f,S),y(F,S,null),o(S,ke),o(S,re),o(S,je),y(G,S,null),o(f,Ce),o(f,M),y(Q,M,null),o(M,Ze),o(M,pe),o(M,Ge),y(L,M,null),o(M,Le),y(W,M,null),o(f,We),o(f,N),y(q,N,null),o(N,Ne),o(N,ce),o(f,Ve),o(f,I),y(Y,I,null),o(I,Xe),o(I,de),o(I,Be),y(V,I,null),o(I,ze),y(X,I,null),o(f,Ee),o(f,B),y(O,B,null),o(B,Re),o(B,fe),o(f,Ae),o(f,z),y(H,z,null),o(z,Fe),o(z,me),m(e,ye,l),y(K,e,l),m(e,ve,l),m(e,j,l),y(ee,j,null),o(j,Qe),o(j,ue),m(e,$e,l),y(te,e,l),m(e,xe,l),m(e,he,l),Te=!0},p(e,[l]){const g={};l&2&&(g.$$scope={dirty:l,ctx:e}),Z.$set(g);const C={};l&2&&(C.$$scope={dirty:l,ctx:e}),G.$set(C);const J={};l&2&&(J.$$scope={dirty:l,ctx:e}),L.$set(J);const ne={};l&2&&(ne.$$scope={dirty:l,ctx:e}),W.$set(ne);const P={};l&2&&(P.$$scope={dirty:l,ctx:e}),V.$set(P);const se={};l&2&&(se.$$scope={dirty:l,ctx:e}),X.$set(se)},i(e){Te||(v(u.$$.fragment,e),v(Z.$$.fragment,e),v(R.$$.fragment,e),v(A.$$.fragment,e),v(F.$$.fragment,e),v(G.$$.fragment,e),v(Q.$$.fragment,e),v(L.$$.fragment,e),v(W.$$.fragment,e),v(q.$$.fragment,e),v(Y.$$.fragment,e),v(V.$$.fragment,e),v(X.$$.fragment,e),v(O.$$.fragment,e),v(H.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),Te=!0)},o(e){$(u.$$.fragment,e),$(Z.$$.fragment,e),$(R.$$.fragment,e),$(A.$$.fragment,e),$(F.$$.fragment,e),$(G.$$.fragment,e),$(Q.$$.fragment,e),$(L.$$.fragment,e),$(W.$$.fragment,e),$(q.$$.fragment,e),$(Y.$$.fragment,e),$(V.$$.fragment,e),$(X.$$.fragment,e),$(O.$$.fragment,e),$(H.$$.fragment,e),$(K.$$.fragment,e),$(ee.$$.fragment,e),$(te.$$.fragment,e),Te=!1},d(e){e&&(a(_),a(i),a(s),a(t),a(h),a(_e),a(be),a(we),a(f),a(ye),a(ve),a(j),a($e),a(xe),a(he)),a(n),x(u,e),x(Z,e),x(R,e),x(A),x(F),x(G),x(Q),x(L),x(W),x(q),x(Y),x(V),x(X),x(O),x(H),x(K,e),x(ee),x(te,e)}}}const Tt='{"title":"Super-resolution","local":"super-resolution","sections":[{"title":"StableDiffusionUpscalePipeline","local":"diffusers.StableDiffusionUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ut(U){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends mt{constructor(n){super(),ut(this,n,Ut,xt,dt,{})}}export{jt as component};
