/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.encoder;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.encoder.AbstractEncoder;
import co.nstant.in.cbor.encoder.DoublePrecisionFloatEncoder;
import co.nstant.in.cbor.encoder.HalfPrecisionFloatEncoder;
import co.nstant.in.cbor.encoder.SinglePrecisionFloatEncoder;
import co.nstant.in.cbor.model.DoublePrecisionFloat;
import co.nstant.in.cbor.model.HalfPrecisionFloat;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.SimpleValueType;
import co.nstant.in.cbor.model.SinglePrecisionFloat;
import co.nstant.in.cbor.model.Special;
import java.io.OutputStream;

public class SpecialEncoder
extends AbstractEncoder<Special> {
    private final HalfPrecisionFloatEncoder halfPrecisionFloatEncoder;
    private final SinglePrecisionFloatEncoder singlePrecisionFloatEncoder;
    private final DoublePrecisionFloatEncoder doublePrecisionFloatEncoder;

    public SpecialEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
        this.halfPrecisionFloatEncoder = new HalfPrecisionFloatEncoder(encoder, outputStream);
        this.singlePrecisionFloatEncoder = new SinglePrecisionFloatEncoder(encoder, outputStream);
        this.doublePrecisionFloatEncoder = new DoublePrecisionFloatEncoder(encoder, outputStream);
    }

    @Override
    public void encode(Special dataItem) throws CborException {
        block0 : switch (dataItem.getSpecialType()) {
            case BREAK: {
                this.write(255);
                break;
            }
            case SIMPLE_VALUE: {
                SimpleValue simpleValue = (SimpleValue)dataItem;
                switch (simpleValue.getSimpleValueType()) {
                    case FALSE: 
                    case NULL: 
                    case TRUE: 
                    case UNDEFINED: {
                        SimpleValueType type = simpleValue.getSimpleValueType();
                        this.write(0xE0 | type.getValue());
                        break block0;
                    }
                    case UNALLOCATED: {
                        this.write(0xE0 | simpleValue.getValue());
                        break block0;
                    }
                }
                break;
            }
            case IEEE_754_HALF_PRECISION_FLOAT: {
                this.halfPrecisionFloatEncoder.encode((HalfPrecisionFloat)dataItem);
                break;
            }
            case IEEE_754_SINGLE_PRECISION_FLOAT: {
                this.singlePrecisionFloatEncoder.encode((SinglePrecisionFloat)dataItem);
                break;
            }
            case IEEE_754_DOUBLE_PRECISION_FLOAT: {
                this.doublePrecisionFloatEncoder.encode((DoublePrecisionFloat)dataItem);
                break;
            }
            case SIMPLE_VALUE_NEXT_BYTE: {
                SimpleValue simpleValueNextByte = (SimpleValue)dataItem;
                this.write(-8, (byte)simpleValueNextByte.getValue());
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown special value type");
            }
        }
    }
}

